/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.planning.mokos.AbstractPlanningScorer;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class WorkplaceBasedScorer
extends AbstractPlanningScorer<Long> {
    private Set<String> speciallyHandledWorkplaces = Collections.emptySet();
    private String specialScoreKey;
    private String normalScoreKey;

    public WorkplaceBasedScorer() {
        super("workplace_based_score");
    }

    public void setSpeciallyHandledWorkplaces(Collection<String> wps) {
        Preconditions.checkNotNull(wps);
        this.speciallyHandledWorkplaces = Sets.newHashSet(wps);
    }

    public void setNormalScoreKey(String normalScoreKey) {
        this.normalScoreKey = normalScoreKey;
    }

    public void setSpecialScoreKey(String specialScoreKey) {
        this.specialScoreKey = specialScoreKey;
    }

    @Override
    protected Long getPlanningScore(Operation op, Operation.OperationPlanning planning) {
        Long res;
        ActionActivity plannedAa = Util.getFirstPlannedAa(planning);
        if (plannedAa != null && this.speciallyHandledWorkplaces.contains(plannedAa.getWorkplace().getName())) {
            res = (Long)planning.getProperty(this.specialScoreKey);
            Preconditions.checkNotNull(res, "%s score key not set for planning %s.", (Object)this.specialScoreKey, (Object)planning);
        } else {
            res = (Long)planning.getProperty(this.normalScoreKey);
            Preconditions.checkNotNull(res, "%s score key not set for planning %s.", (Object)this.normalScoreKey, (Object)planning);
        }
        return res;
    }
}

